package gov.va.med.mhv.sm.api.transfer;

import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "Folder")
public class FolderTO implements Serializable {
	private static final long serialVersionUID = 5022828655462357347L;

	private long id;
	private String name;
	private int count;
	private int unreadCount;
	private boolean isSystemFolder;

	public FolderTO() {
	}

	public FolderTO(long id, String name, int count, int unreadCount) {
		this.id = id;
		this.name = name;
		this.count = count;
		this.unreadCount = unreadCount;
	}
	
	public FolderTO(long id, String name, int count, int unreadCount, SystemFolderEnum systemFolderEnum) {
		this.id = id;
		this.name = name;
		this.count = count;
		this.unreadCount = unreadCount;
		if( null != systemFolderEnum ) {
			this.isSystemFolder = true;
			this.name = systemFolderEnum.getName();
		}
	}

	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public int getCount() {
		return count;
	}
	public void setCount(int count) {
		this.count = count;
	}
	public int getUnreadCount() {
		return unreadCount;
	}
	public void setUnreadCount(int unreadCount) {
		this.unreadCount = unreadCount;
	}
	public boolean isSystemFolder() {
		return isSystemFolder;
	}
	public void setSystemFolder(boolean isSystemFolder) {
		this.isSystemFolder = isSystemFolder;
	}

	public String toString() {
		return "Folder {id="+this.getId()+";name="+this.getName()+";Count="+this.getCount()+";Unread count="+this.getUnreadCount()+";isSystemFolder:"+this.isSystemFolder()+"}";
	}
}
